TOOL.Category		= "Destruction"
TOOL.Name			= "Bomb"
TOOL.Command		= nil
TOOL.ConfigName		= "" // returning nil had made my control panel not function correctly

// defaults
TOOL.ClientConVar["model"] = "models/Combine_Helicopter/helicopter_bomb01.mdl" // model
TOOL.ClientConVar["damage"] = 100 // damage
TOOL.ClientConVar["radius"] = 300 // radius
TOOL.ClientConVar["delay"] = 5 // delay

// List of models
local ModelList = {
"models/Combine_Helicopter/helicopter_bomb01.mdl",
"models/props_junk/watermelon01.mdl",
"models/props_c17/oildrum001.mdl",
"models/props_c17/canister01a.mdl",
"models/props_borealis/bluebarrel001.mdl",
"models/props_junk/popcan01a.mdl",
"models/props_trainstation/trainstation_clock001.mdl",
"models/roller.mdl"
}

cleanup.Register("Bomb")

if SERVER then
	// create the "max limit" console command
	CreateConVar("sbox_maxbombs",5)
end

if CLIENT then
	language.Add("Tool_bomb_name","Bomb Tool")
	language.Add("Tool_bomb_desc","Spawn bombs!")
	language.Add("Tool_bomb_0","Left click to spawn a bomb.")
	language.Add("SBoxLimit_Bombs","You have hit the bomb limit!") // Limit message
	language.Add("Undone_Bomb","Bomb undone") // undone message
	language.Add("Tool_bomb_author","By: SuperSpecialSenior (mr no no)")
end

function TOOL:LeftClick(trace)
	if (!trace.HitPos) || trace.Entity:IsPlayer() then
		return false
	end
	if CLIENT then
		return true
	end
	local model = self:GetClientInfo("model")
	local damage = math.Clamp(self:GetClientNumber("damage"),0,1500) // clamp it
	local radius = math.Clamp(self:GetClientNumber("radius"),0,1500) // clamp
	local delay = self:GetClientNumber("delay")
	// Update the bomb if we shoot at one
	if (trace.Entity:IsValid() && (trace.Entity:GetClass() == "gmod_bomb") && (trace.Entity:GetTable():GetPlayer() == self:GetOwner())) then
		trace.Entity:GetTable():SetDamage(damage) // set the new damage
		trace.Entity:GetTable():SetRadius(radius) // set the new radius
		trace.Entity:GetTable():SetDelay(delay) // set the new delay
		return true
	end
	// Check the limit
	if !self:GetSWEP():CheckLimit("Bombs") then
		return false
	end
	if !self:GetOwner():CheckLimit("Bombs") then
		return nil
	end
	local Bomb = ents.Create("gmod_bomb")
	Bomb:SetModel(model)
	Bomb:SetPos(trace.HitPos - trace.HitNormal * Bomb:OBBMins().z) // The entity should spawn at the same position as its ghost
	Bomb:SetAngles(Angle(90,0,0))
	Bomb:GetTable():SetDamage(damage)
	Bomb:GetTable():SetDelay(delay)
	Bomb:GetTable():SetRadius(radius)
	Bomb:SetPlayer(self:GetOwner()) // base_gmodentity stuff
	Bomb:Spawn()
	self:GetOwner():AddCount("Bombs",Bomb)
	// Add it to cleanup list
	self:GetOwner():AddCleanup("Bomb",Bomb)
	// add it to the undo list
	undo.Create("Bomb")
	undo.AddEntity(Bomb)
	undo.SetPlayer(self:GetOwner())
	undo.Finish()
	return true
end

function TOOL:RightClick(trace)
	return self:LeftClick(trace)
end

function TOOL:Reload(trace)
	return self:LeftClick(trace)
end

function TOOL:UpdateGhostBomb(ent,player)
	if (!ent || !ent:IsValid()) then
		return
	end
	local trace = util.TraceLine(util.GetPlayerTrace(player,player:GetCursorAimVector()))
	// Hide ghost when cursor is over a bomb or player
	if (!trace.Hit || trace.Entity:IsPlayer() || trace.Entity:GetClass() == "gmod_bomb") then
		ent:SetNoDraw(true)
		return
	end
	local Ang = Angle(90,0,0)
	ent:SetAngles(Ang)
	ent:SetPos(trace.HitPos - trace.HitNormal * ent:OBBMins().z) // The entity should spawn at the same position as its ghost
	ent:SetNoDraw(false)
end

function TOOL:Think()
	if (!self.GhostEntity || !self.GhostEntity:IsValid() || self.GhostEntity:GetModel() != self:GetClientInfo("model")) then
		self:MakeGhostEntity(self:GetClientInfo("model"),Vector(0,0,0),Angle(0,0,0))
	end
	self:UpdateGhostBomb(self.GhostEntity,self:GetOwner())
end

function TOOL.BuildCPanel(CPanel)
	// Header
	CPanel:AddControl("Header",{Text = "#Tool_bomb_name",Description = "#Tool_bomb_author"})
	// Model selection
	local ModelTable = {Label = "Model:",ConVar = "bomb_model",Category = "Destruction",Models = {}}
	for k,v in pairs(ModelList) do
		ModelTable["Models"][v] = {}
	end
	CPanel:AddControl("PropSelect",ModelTable)
	// Sliders
	CPanel:AddControl("Slider",{Label = "Set damage:",Description = "The amount of damage given by the bomb",Type = "Numeric",Min = "0",Max = "1500",Command = "bomb_damage"}) // Damage
	CPanel:AddControl("Slider",{Label = "Set radius:",Description = "The radius of the explosion",Type = "Numeric",Min = "0",Max = "1500",Command = "bomb_radius"}) // Radius
	CPanel:AddControl("Slider",{Label = "Set delay:",Description = "The amount of time it takes until the bomb explodes",Type = "Numeric",Min = "0",Max = "120",Command = "bomb_delay"}) // Delay
end
