// Send client files
AddCSLuaFile("cl_init.lua")
AddCSLuaFile("shared.lua")

// Include shared file
include("shared.lua")

ENT.Damage = 0
ENT.Radius = 0
ENT.Delay = 0
ENT.SetTime = 0
ENT.TimeLeft = 0

function ENT:Initialize()
	// set up physics
	self.Entity:PhysicsInit(SOLID_VPHYSICS)
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS)
	self.Entity:SetSolid(SOLID_VPHYSICS)
	local phys = self.Entity:GetPhysicsObject()
	if phys:IsValid() then
		phys:Wake()
	end
end

function ENT:SetDamage(damage)
	self.Damage = damage
end

function ENT:SetDelay(delay)
	self.Delay = delay
	self.SetTime = CurTime()
end

function ENT:SetRadius(radius)
	self.Radius = radius
end

function ENT:OnTakeDamage(dmginfo)
	// The bomb explodes if it is shot at
	if dmginfo:IsBulletDamage() then
		self:Explode()
	end
end

function ENT:Think()
	// base_gmodentity's tooltip-type thing when you move the cursor over the prop
	self:SetOverlayText("Radius: "..math.Round(self.Radius).."\nDamage: "..math.Round(self.Damage).."\nDelay: "..math.Round(self.TimeLeft))
	if !self.Entity:IsValid() then
		return
	end
	local timeleft = CurTime() - self.SetTime
	self.TimeLeft = self.Delay - timeleft
	// The bomb will gradually become redder every frame before it finally explodes
	local fade = (self.TimeLeft/self.Delay) * 255
	self.Entity:SetColor(255,0 + fade,0 + fade,255)
	// If the bomb is out of time...
	if timeleft >= self.Delay then
		self:Explode()
	end
end

function ENT:Explode()
	local ent = self.Entity
	local pos = ent:LocalToWorld(ent:OBBCenter())
	local rad = self.Radius
	local dmg = self.Damage
	local owner = self:GetPlayer()
	if !owner:IsValid() then
		owner = ent
	end
	self.Entity:Remove()
	local effectdata = EffectData()
	effectdata:SetOrigin(pos)
	// Explosion effect
 	util.Effect("Explosion",effectdata)
	local ed = EffectData()
	ed:SetOrigin(pos)
	ed:SetNormal(Vector(0,0,1))
	ed:SetRadius(rad)
	// Nice little effect
 	util.Effect("cball_bounce",ed)
	// Add some blast damage
 	util.BlastDamage(ent,owner,pos,rad,dmg)
end
