//---------------------------------------------------------------------------------------------------
// Author: imhenrythe8thim
// Contact: imhenrythe8thim@yahoo.com
// Website: http://imhenrythe8thim.tripod.com/
//
// ChangeLog:
// 25/Nov/2007 - Added debug code to show an error if the file/folder cannot be opened.
// 22/Nov/2007 - Version 1
//---------------------------------------------------------------------------------------------------

// include header file
#include <iostream>
#include <cstring>
#include <windows.h>

int main(int argc, char *argv[])
{
 	if (argc <= 1)
 	{
	   		 std::cout<<"Shortcuts.exe - A Commandline Application\n";
	   		 std::cout<<"By imhenrythe8thim\n";
	   		 std::cout<<"Description: Use this program to open folders, launch other programs, etc. ";
	   		 std::cout<<"This was originally made as a shortcut replacement for windows so that it could be pinned to the start menu."; // I wanted to pin a shortcut to a folder onto the start menu and this was the only way I could think of doing it.
	   		 std::cout<<"To use: Run this program with a commandline argument.\nFor example:\nUse \"C:\\MyFolder\\\" to open MyFolder\nOr\nUse \"C:\\MyFolder\\MyApp.exe\" to execute MyApp.exe.\n";
	   		 std::cin.get();
	   		 return EXIT_SUCCESS;
	}
	int len = strlen(argv[1]);
 	char * Location = new char[len];
 	Location[0] = '\0';
 	strcat(Location,argv[1]);
 	HINSTANCE__* success = ShellExecute(NULL, "open", Location, NULL, NULL, SW_SHOW); // open the folder/program/website/whatever using the arg given
	if (((int)success < 33) && ((int)success >= 0)) // check to see if file/folder was executed correctly
 	{
	   		 char * ErrorMsg = new char[28 + len];
	   		 ErrorMsg[0] = '\0';
			 strcat(ErrorMsg,"Error - ");
			 strcat(ErrorMsg,Location);
	 		 delete [] Location;
	 		 strcat(ErrorMsg," could not be opened");
	   		 MessageBox(NULL, "Please check for any spelling mistakes or enclose the location of the file/folder in quotes and try again.", ErrorMsg, MB_OK); // display error if the file/folder was not found
	   		 delete [] ErrorMsg;
	}
    return EXIT_SUCCESS;
}
